#!/usr/bin/perl
#

$V = "Links Builder 2.2.8";
print $V."\n";

# -----------------------------------------------------------------------------
# Create the product installer for each language
# -----------------------------------------------------------------------------

$num_lang = 6;

@languages		=	(
					"English",
					"German",
					"French",
					"Spanish",
					"Dutch",
					"Chinese",
					);

@product_file	= 	(
					"../../release/product-eirma_ldm.xml",
					"../../release/product-eirma_ldm_de.xml",
					"../../release/product-eirma_ldm_fr.xml",
					"../../release/product-eirma_ldm_es.xml",
					"../../release/product-eirma_ldm_nl.xml",
					"../../release/product-eirma_ldm_cn.xml",
					);

@phrase_file	= 	(
					"../phrases/phrases_en.xml",
					"../phrases/phrases_de.xml",
					"../phrases/phrases_fr.xml",
					"../phrases/phrases_es.xml",
					"../phrases/phrases_nl.xml",
					"../phrases/phrases_cn.xml",
					);

@encoding	= 	(
					"ISO-8859-1",
					"ISO-8859-1",
					"ISO-8859-1",
					"ISO-8859-1",
					"ISO-8859-1",
					"UTF-8",
					);

$productid 		= "eirma_ldm";
$title 			= "Links and Downloads Manager";
$description 	= "Manage a document and link library";
$vborgthread	= "119041";  # vb3.6 version

# -----------------------------------------------------------------------------

my $XML;
$version = "";
open  $XML , "<", "../../release/forums/includes/local_links_init.php" or die "Unable to read version";
while (<$XML>) {$version .= $_;}
close $XML;

$version =~ s/^.*'THIS_VERSION',[\ \t]*'(.*?)'.*$/\1/gs;

$codes = "";
open  $XML , "<", "../codes/codes.xml" or die "Unable to read codes";
while (<$XML>) {$codes .= $_;}
close $XML;

$codes =~ /^.*code version="(\d+.\d+.\d+)".*$/s;
$code_version = $1;

$plugins = "";
open  $XML , "<", "../plugins/plugins.xml" or die "Unable to read plugins";
while (<$XML>) {$plugins .= $_;}
close $XML;

$templates = "";
open  $XML , "<", "../templates/templates.xml" or die "Unable to read templates";
while (<$XML>) {$templates .= $_;}
close $XML;

# -----------------------------------------------------------------------------

print 'Processing version '.$version." files\n";
if ($code_version ne $version and $code_version ne '*') {
	print "*** Warning - version of init file does not match version recorded in codes.xml (".$code_version.")\n";
}

# -----------------------------------------------------------------------------

for my $k (0..$num_lang-1) {

	my $phrases = "";
	open  $XML , "<", $phrase_file[$k] or die "Unable to read phrases $phrase_file[$k]";
	while (<$XML>) {$phrases .= $_;}
	close $XML;
	$phrases =~ s/.*<language.*?>/\t<phrases>/gs;
	$phrases =~ s/<\/language>/\t<\/phrases>/gs;
	my $encode = $encoding[$k];

	$file = <<EOF;
<?xml version="1.0" encoding="#encoding#"?>

<product productid="#productid#" active="1">
	<title>#title#</title>
	<description>#description#</description>
	<version>#version#</version>
	<url>http://www.vbulletin.org/forum/showthread.php?t=#vborgthread#</url>
	<versioncheckurl><![CDATA[http://www.vbulletin.org/forum/misc.php?do=checkversion&t=#vborgthread#]]></versioncheckurl>
	<dependencies>
	</dependencies>
#codes#
#templates#
#plugins#
#phrases#
	<options>
	</options>
	<helptopics>
	</helptopics>
	<cronentries>
	</cronentries>
	<faqentries>
	</faqentries>
</product>
EOF

	$file =~ s/#productid#/$productid/g;
	$file =~ s/#title#/$title/g;
	$file =~ s/#vborgthread#/$vborgthread/g;
	$file =~ s/#description#/$description/g;
	$file =~ s/#version#/$version/g;
	$file =~ s/#codes#/$codes/g;
	$file =~ s/#templates#/$templates/g;
	$file =~ s/#plugins#/$plugins/g;
	$file =~ s/#phrases#/$phrases/g;
	$file =~ s/#encoding#/$encode/g;

	open  $XML , ">", $product_file[$k] or die "Unable to create $product_file[$k]";
	print $XML $file;
	close $XML;

	print 'Built '.$languages[$k]." language product loader\n";

}

# -----------------------------------------------------------------------------
